
/*
          ##      ##  ##########      ##      ########    ##########  ########    ##########      ##      ##########
          ##      ##  ##            ##  ##    ##      ##      ##      ##      ##  ##            ##  ##        ##    
          ##      ##  ##          ##      ##  ##      ##      ##      ##      ##  ##          ##      ##      ##    
          ##########  ######      ##      ##  ########        ##      ########    ######      ##      ##      ##    
          ##      ##  ##          ##########  ##  ##          ##      ##      ##  ##          ##########      ##    
          ##      ##  ##          ##      ##  ##    ##        ##      ##      ##  ##          ##      ##      ##    
          ##      ##  ##########  ##      ##  ##      ##      ##      ########    ##########  ##      ##      ##    
*/

//  Heartbeat
//    freeware by N0ZYC
#define vers "2015.08.22.A"

//  loaded on all my spare Arduino processors to confirm they are blank and working

//  blinks three repeatedly, like a heartbeat
//  very distinctive/unique look.  other sketches with flashing LEDs rarely triple beat like this
//  so you can be confident it's formatted just by looking at the activity light

//  also dumps lots of helpful hardware information to serial
//  additionally dumps and parses EEPROM if formatted using FlashROM format







//  include optional libraries, to gather information on the hardware we are running on
//  if these libraries aren't present, you may see complaints about missing libraries,
//  but it should successfully compile and run, without the added functionality.

#include <arduino_hw.h>  //  library by N0ZYC, gathers hardware information
#include <FlashROM.h>    //  library by N0ZYC, structured EEPROM i/o








boolean welcomed = false;  //  just a flag to keep track of if the user has been welcomed



unsigned long next_uptime = 0;  //  next time (millis) that we will announce our uptime
unsigned long uptime_interval_sec=60;  //  interval (in seconds) we will announce our uptime




void setup() {                

//  init debug output - default serial port speed is 9600, but my popup in the serial window goes to 115200
//  Serial.begin(9600);
  Serial.begin(115200);

  // initialize the digital pin as an output.
  // Pin 13 has an LED connected on most Arduino boards:
  pinMode(arduino_hw_led, OUTPUT);     

}







//  print an unsigned integer (in decimal and hex) to serial

void PrintBytes(unsigned long got_bytes) {
  
  unsigned long b = got_bytes;
  
  Serial.print(b,DEC);
  Serial.print(" ($");
  Serial.print(b,HEX);
  Serial.println(") bytes");

}



//  check available sram

int freeRam () {
  extern int __heap_start, *__brkval; 
  int v; 
  return (int) &v - (__brkval == 0 ? (int) &__heap_start : (int) __brkval); 
}



//  display amount of available SRAM
void CheckSram () {
  uint8_t * heapptr, * stackptr;
  int ramspace;
  stackptr = (uint8_t *)malloc(4);   //  use stackptr temporarily
  heapptr = stackptr;                //  save value of heap pointer
  free(stackptr);                    //  free up the memory again (sets stackptr to 0)
  stackptr =  (uint8_t *)(SP);       //  save value of stack pointer
  ramspace=stackptr-heapptr;         //  from what I've read this is the amount of space between the stack and the heap
  ramspace+=12;                      //  subtract this function's overhead
  Serial.print("SRAM="); Serial.println(ramspace);
}




void do_welcome () {
  
      Serial.println("\n\n\n\n");
      Serial.print("HEARTBEAT ") ; Serial.print(vers); Serial.println(" by N0ZYC\n");
      Serial.println("This Arduino is blank and ready for programming\n");
      
      
      //  if we happen to have N0ZYC's arduino_hw library, report platform attributes
      #ifdef arduino_hw_h
      
        Serial.println("CPU:");
        Serial.print("  Processor: "); Serial.println(arduino_hw_cpu);
        Serial.print("  Platforms: "); Serial.println(arduino_hw_platform);
        Serial.print("  Program Flash (PROGMEM): "); PrintBytes(arduino_hw_pgmflash);
        Serial.print("  Runtime RAM (SRAM): "); PrintBytes(arduino_hw_sram);
        Serial.print("  EEPROM: "); PrintBytes(arduino_hw_eeprom);
        Serial.print("  Clock Speed: "); Serial.print(arduino_hw_mhz); Serial.println(" MHz");
        Serial.print("  Logic Voltage: "); Serial.print(arduino_hw_logic); Serial.println("v");
        Serial.print("  UARTs: "); Serial.println(arduino_hw_uarts);
        Serial.print("  Onboard LED: "); Serial.println(arduino_hw_led);
        Serial.print("  Virtualized Serial: "); if (arduino_hw_virtser) { Serial.println("YES"); } else { Serial.println("NO"); }
        Serial.println("");
        
        Serial.println("I2C/TWI/2wire: ");
        Serial.print("  SCL pin "); Serial.println(arduino_hw_i2c_scl);
        Serial.print("  SDA pin "); Serial.println(arduino_hw_i2c_sda);
        Serial.println("");
        
        Serial.println("SPI: ");
        Serial.print("  MISO pin "); Serial.println(arduino_hw_spi_miso);
        Serial.print("  MOSI pin "); Serial.println(arduino_hw_spi_mosi);
        Serial.print("   SCK pin "); Serial.println(arduino_hw_spi_sck);
        Serial.print("    SS pin "); Serial.print(arduino_hw_spi_ss); Serial.println(" (default)");
        Serial.println("");
        
        Serial.println("GPIO: ");
        Serial.print("  dedicated GPIO pins: ") ; Serial.println(arduino_hw_gpio_only);
        Serial.print("  Analog input pins usable as GPIO: "); Serial.println(arduino_hw_gpio_analog);
        Serial.print("  PWM supported on pins: "); Serial.println(arduino_hw_gpio_pwm);
        Serial.print("  absolute max current per pin: ") ; Serial.println(arduino_hw_gpio_ma);
        Serial.println("");

        Serial.println("Analog Input:");
        Serial.print("  number of pins: "); Serial.println(arduino_hw_aipins,DEC);
        Serial.print("  bits of precision: "); Serial.println(arduino_hw_aibits,DEC);
        Serial.println("");

        Serial.println("Analog Output:");
        Serial.print("  number of pins: "); Serial.println(arduino_hw_aopins,DEC);
        Serial.print("  bits of precision: "); Serial.println(arduino_hw_aobits,DEC);
        Serial.println("");

        Serial.println("Serial:");
        Serial.print("  UART RX pins: "); Serial.print(arduino_hw_rx_pins); Serial.println(" (TX is on pin RX+1)");
        Serial.print("  Change interrupts (SoftwareSerial RX) on pins: "); Serial.println(arduino_chg_int_pins);
        Serial.println("");
  
        Serial.println("Interrupt pins:");
        Serial.print("  int.0: "); Serial.println(arduino_hw_int0);
        Serial.print("  int.1: "); Serial.println(arduino_hw_int1);
        Serial.print("  int.2: "); Serial.println(arduino_hw_int2);
        Serial.print("  int.3: "); Serial.println(arduino_hw_int3);
        Serial.print("  int.4: "); Serial.println(arduino_hw_int4);
        Serial.print("  int.5: "); Serial.println(arduino_hw_int5);

        Serial.println("\n");
      #endif
      
      
      //  if we happen to have N0ZYC's FlashROM library, report eeprom status
      #ifdef FlashROM_h
        Flash.Begin(false,"test");
        if (Flash.Unformatted) {
          Serial.println("EEPROM is unformatted or in a format unfamiliar to FlashROM:");
          Serial.println();
//          Flash.Dump();  //  dump entire contents of EEPROM
          Flash.Dump(0,256);  //  dump first 1/4 KB of EEPROM
        } else {
          Serial.print("EEPROM contains FlashROM-formatted data for sketch \"");
          Serial.print(Flash.SketchName);
          Serial.print("\", data version ");
          Serial.println(Flash.DataVersion,DEC);
          Serial.println();
//          Flash.Dump();  //  dump entire contents of EEPROM
          Flash.Dump(0,1024);  //  dump first 1 KB of EEPROM
        }
        
        //  some of my sketches store something special in the last 2 bytes, such as used sram or checksum
        Serial.print("last uint16_t: ");
        uint16_t hi,lo;
        hi=Flash.EEPROM_read(arduino_hw_eeprom-2);
        lo=Flash.EEPROM_read(arduino_hw_eeprom-1);
        Serial.println((hi*256)+lo,DEC);
        
      #endif
      
      Serial.print("\nfreeRam="); Serial.println(freeRam(),DEC);
      CheckSram();  //  mine, primative but equally effective

      Serial.println("\ndone.");
      welcomed = true;
    }





void loop() {

  //  send a welcome to the serial port if/when it appears
  //  only really important for Leonardo / Mini since they virtualize their serial port
  if (Serial) {
    if (not welcomed) {
      do_welcome();
    }
  } else {
    //  serial not open, OR it has been closed
    //  this will trigger another welcome if they re-open the serial connection
    welcomed = false;
  }

  if (millis() > next_uptime) {
    Serial.print("uptime: ");
    Serial.print(millis(),DEC);
    Serial.println("ms");
    next_uptime=(next_uptime+1000*uptime_interval_sec);
  }

  //  blink light on/off for 1/10 sec, three times.  tried two, but so many other things were doing that, we need to be unique
  for (int b=0;b<3;b++) {
    digitalWrite(arduino_hw_led, HIGH);
    delay(100);
    digitalWrite(arduino_hw_led, LOW);
    delay(100);
  }


  //  (pause)
  delay(500);


}




