/*

arduino_hw - by N0ZYC
2016.02.12.A
if you make changes here, you may want to update the Heartbeat sketch too?
and also keywords file?

See included examples for use

*/




#ifndef arduino_hw_h
#define arduino_hw_h 1


//  just going to define some things for hardware identification
//  checks for compiler definitions set by your "board" selection
//  prior to compiling.  pins refer to shield pin placements except
//  where noted with "pinXX".  Those refer to physical position on a dip arrangement.

//  These aren't necvessarily intended for sketch access, but more for reminders for devs.
//  The Heartbeat sketch specifically dumps this data to serial, I recommend loading Heartbeat
//  on any of your available Arduino CPUs.

//  analog pins like "A5" will be resolved to their true numeric pin ("A5" is actually pin 59 on a mega2560)
//  analog pins can be used as digital pins, define them the same way with pinMode(),
//    they will revert back to being an analog pin when you next call analogRead() on them.


#ifdef __AVR_ATmega32U4__
  #define arduino_hw_cpu "ATmega32u4"             //  cpu name string
  #define arduino_hw_cpu_id 1                     //  cpu index (arbitrarily chosen by me)
  #define arduino_hw_platform "Leonardo, Micro"   //  common platforms string
  #define arduino_hw_pgmflash 32768               //  bytes of program flash
  #define arduino_hw_sram 2560                    //  bytes of sram (working ram)
  #define arduino_hw_eeprom 1024                  //  bytes of EEPROM
  #define arduino_hw_mhz 16                       //  CPU MHz
  #define arduino_hw_logic 5                      //  logic voltage
  #define arduino_hw_i2c_sda 2                    //  i2c SDA pin
  #define arduino_hw_i2c_scl 3                    //  i2c SCL pin
  #define arduino_hw_spi_miso 16                  //  spi MISO pin (unchangeable)
  #define arduino_hw_spi_mosi 18                  //  spi MOSI pin (unchangeable)
  #define arduino_hw_spi_sck 17                   //  spi SCK pin (unchangeable)
  #define arduino_hw_spi_ss 19                    //  spi ss pin
  #define arduino_hw_gpio_pwm "3,5,6,9,10,11,13"  //  pins supporting PWM
  #define arduino_hw_aipins 12                    //  total analog input pins
  #define arduino_hw_aibits 10                    //  bits of precision on analog inputs
  #define arduino_hw_aopins 0                     //  total analog output pins
  #define arduino_hw_aobits 0                     //  bits of precision on analog outputs
  #define arduino_chg_int_pins "8-11,14-16"       //  digital pins supporting change interrupts (for softwareserial rx etc)
  #define arduino_hw_uarts 1                      //  total UARTs (SERIALx)
  #define arduino_hw_rx_pins "0"                  //  serial port rx pins (tx=rx+1)   can be a list, leave it a string
  #define arduino_hw_int0 3                       //  interrupt 0 pin   http://arduino.cc/en/Reference/AttachInterrupt
  #define arduino_hw_int1 2                       //  interrupt 1 pin
  #define arduino_hw_int2 0                       //  interrupt 2 pin
  #define arduino_hw_int3 1                       //  interrupt 3 pin
  #define arduino_hw_int4 7                       //  interrupt 4 pin
  #define arduino_hw_int5 "na"                    //  interrupt 5 pin
  #define arduino_hw_virtser true                 //  serial port is virtualized
  #define arduino_hw_led 13                       //  dpin with a built-in LED
  #define arduino_hw_gpio_ma "unknown"            //  allowable DC current draw on GPIO pins
  #define arduino_hw_gpio_analog "all"            //  analog input pins that can be used as GPIO
  #define arduino_hw_gpio_only "0-13"             //  dedicated GPIO pins
#endif

#ifdef __AVR_ATmega168__
  #define arduino_hw_cpu "ATmega168"
  #define arduino_hw_cpu_id 2
  #define arduino_hw_platform "Nano/128, Diecimila, and older"
  #define arduino_hw_pgmflash 16384
  #define arduino_hw_sram 1024
  #define arduino_hw_eeprom 512
  #define arduino_hw_mhz 20
  #define arduino_hw_logic 5
  #define arduino_hw_i2c_sda "A4"
  #define arduino_hw_i2c_scl "A5"
  #define arduino_hw_spi_miso 12
  #define arduino_hw_spi_mosi 11
  #define arduino_hw_spi_sck 13
  #define arduino_hw_spi_ss 10
  #define arduino_hw_gpio_pwm "3,5,6,9,10,11"
  #define arduino_hw_aipins 6
  #define arduino_hw_aibits 10
  #define arduino_hw_aopins 0
  #define arduino_hw_aobits 0
  #define arduino_chg_int_pins "2,3"
  #define arduino_hw_uarts 1
  #define arduino_hw_rx_pins "0"
  #define arduino_hw_int0 2
  #define arduino_hw_int1 3
  #define arduino_hw_int2 "na"
  #define arduino_hw_int3 "na"
  #define arduino_hw_int4 "na"
  #define arduino_hw_int5 "na"
  #define arduino_hw_virtser false
  #define arduino_hw_led 13
  #define arduino_hw_gpio_ma "unknown"
  #define arduino_hw_gpio_analog "all"
  #define arduino_hw_gpio_only "0-13"
#endif

#ifdef __AVR_ATmega328P__
  #define arduino_hw_cpu "ATmega328P"
  #define arduino_hw_cpu_id 3
  #define arduino_hw_platform "Ardweeny, Duemilanove, Uno, Pro Mini, Ethernet, Nano/328, Moteino"
  #define arduino_hw_pgmflash 32768
  #define arduino_hw_sram 2048
  #define arduino_hw_eeprom 1024
  #define arduino_hw_mhz 20
  #define arduino_hw_logic 5
  #define arduino_hw_i2c_sda "A4"
  #define arduino_hw_i2c_scl "A5"
  #define arduino_hw_spi_miso 12
  #define arduino_hw_spi_mosi 11
  #define arduino_hw_spi_sck 13
  #define arduino_hw_spi_ss 10
  #define arduino_hw_gpio_pwm "3,5,6,9,10,11"
  #define arduino_hw_aipins 8  //  may have only 4 broken out on the common 24 pin dip, or broken out inside the board perimiter
  #define arduino_hw_aibits 10
  #define arduino_hw_aopins 0
  #define arduino_hw_aobits 0
  #define arduino_chg_int_pins "all?"
  #define arduino_hw_uarts 1
  #define arduino_hw_rx_pins "0"
  #define arduino_hw_int0 2
  #define arduino_hw_int1 3
  #define arduino_hw_int2 "na"
  #define arduino_hw_int3 "na"
  #define arduino_hw_int4 "na"
  #define arduino_hw_int5 "na"
  #define arduino_hw_virtser false
  #ifdef MOTEINO
    #define arduino_hw_led  9  //  d9 if Moteino, but I can't check?  you will have to #define MOTEINO so it knows, I can't find any way to identify it
  #else
    #define arduino_hw_led 13  //  otherwise everyone else on the planet uses pin 13
  #endif
  #define arduino_hw_gpio_ma "40"
  #define arduino_hw_gpio_analog "all"
  #define arduino_hw_gpio_only "0-13"
#endif

#ifdef __AVR_ATmega1280__
  #define arduino_hw_cpu "ATmega1280"  //  very similar to the mega2560
  #define arduino_hw_cpu_id 4
  #define arduino_hw_platform "Mega"
  #define arduino_hw_pgmflash 131072
  #define arduino_hw_sram 8192
  #define arduino_hw_eeprom 4096
  #define arduino_hw_mhz 16
  #define arduino_hw_logic 5
  #define arduino_hw_i2c_sda 20
  #define arduino_hw_i2c_scl 21
  #define arduino_hw_spi_miso 50
  #define arduino_hw_spi_mosi 51
  #define arduino_hw_spi_sck 52
  #define arduino_hw_spi_ss 53
  #define arduino_hw_gpio_pwm "2-13,44-46"
  #define arduino_hw_aipins 16
  #define arduino_hw_aibits 10
  #define arduino_hw_aopins 0
  #define arduino_hw_aobits 0
  #define arduino_chg_int_pins "10-15, 50-53, A8-A15"  //  A8-A15 are aka D62-D69
  #define arduino_hw_uarts 4
  #define arduino_hw_rx_pins "0,19,17,15"
  #define arduino_hw_int0 2
  #define arduino_hw_int1 3
  #define arduino_hw_int2 21
  #define arduino_hw_int3 20
  #define arduino_hw_int4 19
  #define arduino_hw_int5 18
  #define arduino_hw_virtser false
  #define arduino_hw_led 13
  #define arduino_hw_gpio_ma "unknown"
  #define arduino_hw_gpio_analog "all"
  #define arduino_hw_gpio_only "0-53"
#endif

#ifdef __AVR_ATmega2560__
  #define arduino_hw_cpu "ATmega2560"
  #define arduino_hw_cpu_id 5
  #define arduino_hw_platform "Mega 2560"
  #define arduino_hw_pgmflash 262144
  #define arduino_hw_sram 8192
  #define arduino_hw_eeprom 4096
  #define arduino_hw_mhz 16
  #define arduino_hw_logic 5
  #define arduino_hw_i2c_sda 20
  #define arduino_hw_i2c_scl 21
  #define arduino_hw_spi_miso 50
  #define arduino_hw_spi_mosi 51
  #define arduino_hw_spi_sck 52
  #define arduino_hw_spi_ss 53
  #define arduino_hw_gpio_pwm "2-13,44-46"
  #define arduino_hw_aipins 16
  #define arduino_hw_aibits 10
  #define arduino_hw_aopins 0
  #define arduino_hw_aobits 0
  #define arduino_chg_int_pins "10-15, 50-53, A8-A15"  //  A8-A15 are aka D62-D69
  #define arduino_hw_uarts 4
  #define arduino_hw_rx_pins "0,19,17,15"
  #define arduino_hw_int0 2
  #define arduino_hw_int1 3
  #define arduino_hw_int2 21
  #define arduino_hw_int3 20
  #define arduino_hw_int4 19
  #define arduino_hw_int5 18
  #define arduino_hw_virtser false
  #define arduino_hw_led 13
  #define arduino_hw_gpio_ma "unknown"
  #define arduino_hw_gpio_analog "all"
  #define arduino_hw_gpio_only "0-53"
#endif

#ifdef __SAM3X8E__
  #define arduino_hw_cpu "SAM3X8E"
  #define arduino_hw_cpu_id 6
  #define arduino_hw_platform "Due"
  #define arduino_hw_pgmflash 524288
  #define arduino_hw_sram 98304
  #define arduino_hw_eeprom 262144
  #define arduino_hw_mhz 84
  #define arduino_hw_logic 3
  #define arduino_hw_i2c_sda 20
  #define arduino_hw_i2c_scl 21
  #define arduino_hw_spi_miso 50
  #define arduino_hw_spi_mosi 51
  #define arduino_hw_spi_sck 52
  #define arduino_hw_spi_ss 53
  #define arduino_hw_gpio_pwm "unknown"
  #define arduino_hw_aipins 12
  #define arduino_hw_aibits 12
  #define arduino_hw_aopins 2
  #define arduino_hw_aobits 12
  #define arduino_chg_int_pins "all"      //  due supports interrupts on ALL pins, RTFM
  #define arduino_hw_uarts 4
  #define arduino_hw_rx_pins "0"
  #define arduino_hw_int0 "user defined"  //  another RTFM
  #define arduino_hw_int1 "user defined"
  #define arduino_hw_int2 "user defined"
  #define arduino_hw_int3 "user defined"
  #define arduino_hw_int4 "user defined"
  #define arduino_hw_int5 "user defined"
  #define arduino_hw_virtser false
  #define arduino_hw_led 13
  #define arduino_hw_gpio_ma "unknown"
  #define arduino_hw_gpio_analog "all"
  #define arduino_hw_gpio_only "0-53"
#endif


#ifdef __AVR_ATmega1284P__
  //  Moteino MEGA  https://lowpowerlab.com/moteino/
  #define arduino_hw_cpu "ATMega1284P"
  #define arduino_hw_cpu_id 7
  #define arduino_hw_platform "Moteino Mega"
  #define arduino_hw_pgmflash 131072
  #define arduino_hw_sram 16384
  #define arduino_hw_eeprom 4096
  #define arduino_hw_mhz 16  //  could run at 20 on 4.5v but the Moteino powers it at 3.3v
  #define arduino_hw_logic 3
  #define arduino_hw_i2c_sda 17
  #define arduino_hw_i2c_scl 16
  #define arduino_hw_spi_miso 6
  #define arduino_hw_spi_mosi 5
  #define arduino_hw_spi_sck 7
  #define arduino_hw_spi_ss 4
  #define arduino_hw_gpio_pwm "3-4,6-7,12-15"
  #define arduino_hw_aipins 8
  #define arduino_hw_aibits 10
  #define arduino_hw_aopins 0
  #define arduino_hw_aobits 0
  #define arduino_chg_int_pins "unknown"
  #define arduino_hw_uarts 2
  #define arduino_hw_rx_pins "unknown"
  #define arduino_hw_int0 "unknown"
  #define arduino_hw_int1 "unknown"
  #define arduino_hw_int2 "unknown"
  #define arduino_hw_int3 "unknown"
  #define arduino_hw_int4 "unknown"
  #define arduino_hw_int5 "unknown"
  #define arduino_hw_virtser false
  #define arduino_hw_led 15
  #define arduino_hw_gpio_ma "unknown"
  #define arduino_hw_gpio_analog "0-5"
  #define arduino_hw_gpio_only "0-23"
#endif


#ifndef arduino_hw_platform
  #define arduino_hw_cpu "unknown"  //  unknown
  #define arduino_hw_cpu_id 0
  #define arduino_hw_platform "unknown"  //  unknown
  #define arduino_hw_pgmflash 0  //  unknown
  #define arduino_hw_sram 0  //  unknown
  #define arduino_hw_eeprom 0  //  unknown
  #define arduino_hw_mhz 0  //  unknown
  #define arduino_hw_logic 0  //  unknown
  #define arduino_hw_i2c_sda 0  //  unknown
  #define arduino_hw_i2c_scl 0  //  unknown
  #define arduino_hw_spi_miso 0  //  unknown
  #define arduino_hw_spi_mosi 0  //  unknown
  #define arduino_hw_spi_sck 0  //  unknown
  #define arduino_hw_spi_ss 0  //  unknown
  #define arduino_hw_gpio_pwm "unknown"  //  unknown
  #define arduino_hw_aipins 0  //  unknown
  #define arduino_hw_aibits 0
  #define arduino_hw_aopins 0
  #define arduino_hw_aobits 0
  #define arduino_hw_int_pins "unknown"
  #define arduino_hw_uarts 0
  #define arduino_chg_int_pins "unknown"
  #define arduino_hw_int0 "unknown"
  #define arduino_hw_int1 "unknown"
  #define arduino_hw_int2 "unknown"
  #define arduino_hw_int3 "unknown"
  #define arduino_hw_int4 "unknown"
  #define arduino_hw_int5 "unknown"
  #define arduino_hw_virtser false  //  unknown
  #define arduino_hw_led 0  //  unknown
  #define arduino_hw_gpio_ma "unknown"
  #define arduino_hw_gpio_analog "unknown"
  #define arduino_hw_gpio_only "unknown"
#endif

/*

Common Hacks:

hook SPI from shield (Uno etc) to Micro:

sig		micro	Shield
---		-----	------
ss		pin19	D10
mosi	pin18	D11
miso	pin16	D12
sck		pin17	D13


*/

#endif















